/*
 * ServerShutdownHook.java
 *
 * Created on April 1, 2005, 4:03 PM
 */

package ch.epfl.lpd.ids.utils;

/**
 * A shutdown hook used to shutdown correctly the 
 * {@link ch.epfl.lpd.ids.server.ChatServer}.
 * @author Sebastien Baehni
 */
public class ServerShutdownHook implements Runnable {
    
    protected String msg="";
    
    /**
     * Creates a new instance of the ServerShutdownHook. 
     * @param msg The message to display when the shutdown hook is 
     * called.
     */
    public ServerShutdownHook(String msg) {
        this.msg = msg;
    }
    
    /**
     * We simply print a good bye message.
     */
    public void run() {
        System.out.println(this.msg);
    }
    
}
