/*
 * MyPriorityBlockingQueue.java
 *
 * Created on March 9, 2005, 8:33 AM
 */

package ch.epfl.lpd.ids.utils;

import java.util.concurrent.PriorityBlockingQueue;

/**
 * Class implementing the {@link ch.epfl.lpd.ids.utils.IBlockingQueue}
 * class.  This class is just a wrapper around a {@link
 * java.util.concurrent.PriorityBlockingQueue}.
 * @author Sebastien Baehni
 */
public class MyPriorityBlockingQueue<T> implements IBlockingQueue<T> {

    /**
     * The {@link java.util.concurrent.PriorityBlockingQueue} that
     * contains all the objects of this queue.
     */
    protected PriorityBlockingQueue<T> messages;
    
    /**
     * Creates a new instance of MyPriorityBlockingQueue, i.e., a new
     * {@link java.util.concurrent.PriorityBlockingQueue}.
     */
    public MyPriorityBlockingQueue() {
        this.messages = new PriorityBlockingQueue<T>();
    }
    
     /**
     * This method simply calls the <CODE>offer()</CODE> method of the 
     * {@link java.util.concurrent.PriorityBlockingQueue}.
     * @param obj The object to offer.
     */
    public void put(T obj) {
        this.messages.offer(obj);        
    }
    
    /**
     * This method simply calls the <CODE>take()</CODE> method of the
     * {@link java.util.concurrent.PriorityBlockingQueue}. It returns
     * the last element of the queue.
     * @return The last element of the queue that has not already been
     * retrieved.
     * @throws java.lang.InterruptedException If an exception occurs
     * while retrieving the last element of this queue.
     */
    public T get() throws InterruptedException {
        return this.messages.take();
    }
    
}
