/*
 * Message.java
 *
 * Created on March 7, 2005, 7:53 AM
 */

package ch.epfl.lpd.ids.serialization;

/**
 * Class implementing the {@link
 * ch.epfl.lpd.ids.serialization.IMessage} specification.
 * @author Sebastien Baehni
 */
public class Message implements IMessage {

    /**
     * The header of the message.
     */
    protected String header = "";

    /**
     * The data of the message.
     */
    protected byte[] data;


    /**
     * Creates a new instance of Message. This instance sets the
     * header and the data of the message.
     * @param header The header of the message.
     * @param data The data of the message.
     */
    public Message(String header, byte[] data) {
        this.header = header;
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, this.data.length);
    }

    /**
     * Method used to retrieve the header of the message.
     * @return The header of the message.
     */
    public String getHeader() {
        return this.header;
    }
    
    /**
     * Method used to set the header of the message.
     * @param header The header of the message.
     */
    public void setHeader(String header) {
        this.header = header;
    }
    
    /**
     * Method used to retrieve the data of the message.
     * @return The data of the message.
     */
    public byte[] getData() {
        return this.data;
    }
    
    /**
     * Method used to set the data of the message.
     * @param data An array of bytes representing the data of the message.
     */
    public void setData(byte[] data) {
        System.arraycopy(data, 0, this.data, 0, this.data.length);
    }
    
    /**
     * Method used to print this message as a string representation.
     * @return The string representation of this message.
     */
    public String toString() {
        return this.header+"\n"+new String(this.data);
    }
    
    
    
}
