/*
 * IMessage.java
 *
 * Created on March 7, 2005, 7:52 AM
 */

package ch.epfl.lpd.ids.serialization;

import java.io.Serializable;

/**
 * Specification of a message that will be sent between the clients
 * and the server.
 * @author Sebastien Baehni
 */
public interface IMessage extends Serializable {

    /**
     * Method used to retrieve the header of the message.
     * @return The header of the message.
     */
    public String getHeader();

     /**
     * Method used to retrieve the data of the message.
     * @return The data of the message.
     */
    public byte[] getData();

    /**
     * Method used to set the header of the message.
     * @param header The header of the message.
     */
    public void setHeader(String header);

    /**
     * Method used to set the data of the message.
     * @param data The data of the message.
     */
    public void setData(byte[] data);
    
}
