/*
 * ClientShutdownHook.java
 *
 * Created on April 3, 2005, 9:43 AM
 */

package ch.epfl.lpd.ids.utils;

import ch.epfl.lpd.ids.client.IChatClient;

/**
 * Thread called when a Ctrl-C is performed or a System.exit().
 * This thread ensures that the client is disconnected from the server
 * correctly.
 * @author Sebastien Baehni
 */
public class ClientShutdownHook implements Runnable{
    
    /**
     * The client to disconnect
     */
    protected IChatClient icc;
    
    /** Creates a new instance of ClientShutdownHook.
     * We simply initialize the client structure with the one
     * given as parameter.
     * @param icc The chat client to disconnect.
     */
    public ClientShutdownHook(IChatClient icc) {
        this.icc = icc;
    }
    
    /**
     * We disconnect the chat client.
     */
    public void run() {        
        this.icc.disconnect(this.icc.getUsername());            
        System.out.println("Client successfully disconnected.");                      
    }
    
}
