/*
 * IServer.java
 *
 * Created on March 7, 2005, 7:57 AM
 */

package ch.epfl.lpd.ids.server;

import ch.epfl.lpd.ids.serialization.IMessage;
import ch.epfl.lpd.ids.client.IChatClientListener;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * Specification of a chat server. A chat server should be able to
 * accept new chat clients, to accept disconnection of chat clients,
 * to receive messages from these clients. The sending of the messages as well
 * as the list of the connected clients to the clients, will be done with the
 * help of the remote references a server has to its {@link ch.epfl.lpd.ids.client.IChatClientListener}.
 * In order to use RMI, we have to extend the {@link java.rmi.Remote} class.
 * @author Sebastien Baehni
 */
public interface IServer extends Remote {
    /**
     * Used when the server sends a disconnection msg to the client that wants to be disconnected.
     */
    public final String DISCONNECTION_MESSAGE = "DISCONNECTION";
    
    /**
     * Method called by a chat client to connect to this server.
     * @param username The username of the client that wants to connect.
     * @param iccl The {@link ch.epfl.lpd.ids.client.IChatClientListener} reference
     * in order for the server to call methods on it.
     * @return True if the client was able to connect, false otherwise.
     * @throws java.rmi.RemoteException If a remote exception occurs while calling this method.
     */
    public boolean connect(String username,IChatClientListener iccl) throws RemoteException;
    
    
     /**
     * Method called by a chat client when it wants to be
     * disconnected.
     * @param username The username of the chat client that wants to
     * be disconnected.
     * @param iccl The {@link ch.epfl.lpd.ids.client.IChatClientListener} reference
     * in order for the server to call methods on it.
     * @return True if the chat client was able to disconnect, false
     * otherwise.
     * @throws java.rmi.RemoteException If a remote exception occurs while calling this method.
     */
    public boolean disconnect(String username,IChatClientListener iccl) throws RemoteException;
    
     /**
     * Method called by a chat client on the server when the chat
     * client wants to send a new message.    
     * @param msg The {@link ch.epfl.lpd.ids.serialization.IMessage}
     * to send.
     * @throws java.rmi.RemoteException If a remote exception occurs while calling this method.
     */
    public void sendMessage(IMessage msg) throws RemoteException;   
}
