/*
 * ClientGUI.java
 *
 * Created on March 7, 2005, 7:10 AM
 */

package ch.epfl.lpd.ids.gui;

import java.util.Observer;
import java.util.Observable;

import ch.epfl.lpd.ids.serialization.*;
import ch.epfl.lpd.ids.client.IChatClient;


/**
 * This class represents the GUI of a chat client. It receives updates
 * from both {@link ch.epfl.lpd.ids.client.ChatClient} and a {@link
 * ch.epfl.lpd.ids.client.IClientListListener}. This GUI is able to let
 * a user connect and disconnect from a server, to send messages as well as
 * to show the messages received and finally, list the connected clients.
 * This GUI follows the MVC paradigm.
 * @author Sebastien Baehni
 */
public class ClientGUI extends javax.swing.JFrame implements Observer {
    
     /**
     * The {@link ch.epfl.lpd.ids.client.IChatClient} representing a
     * chat client. We do not make a reference to a chat client in
     * order to preserve the encapsulation of the chat client as well
     * as to remain independent of the implementation of a chat
     * client.
     */
    protected IChatClient icc;
    
     /**
     * The username of the user.
     */
    protected String username;
    
    /**
     * Creates a new ClientGUI. This basically means initializing
     * the different variables and showing the GUI.
     * @param icc The chat client that is represented by this GUI.
     */
    public ClientGUI(IChatClient icc) {
        this.icc = icc;
        initComponents();
    }        
    
     /**
     * Method called by the chat client when either: (1) a new {@link
     * ch.epfl.lpd.ids.serialization.IMessage} is received or (2) a
     * list of clients is received.
     * @param o The model (i.e., the chat client).
     * @param arg Either the new {@link
     * ch.epfl.lpd.ids.serialization.IMessage} or the list of
     * connected clients.
     */
    public void update(Observable o, Object arg) {        
        if (arg instanceof IMessage) {            
            String header = ((IMessage)arg).getHeader(); 
            String data = new String(((IMessage)arg).getData());
            this.jTextArea1.append(header+":\n");
            this.jTextArea1.append(data+"\n");
            this.jScrollPane2.getVerticalScrollBar().setValue(this.jScrollPane2.getVerticalScrollBar().getValue()+this.jTextArea1.getHeight());
        }
        if (arg instanceof String[]) {
            this.jList1.setListData((String[])arg);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jTextField1 = new javax.swing.JTextField();
        jButton2 = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jPanel2 = new javax.swing.JPanel();
        jTextField2 = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane(jTextArea1,javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        jTextArea1 = new javax.swing.JTextArea(10,30);

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Chat Client");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closingWindow(evt);
            }
        });

        jPanel1.setLayout(new java.awt.BorderLayout());

        jTextField1.setText("Username");
        jTextField1.setMinimumSize(new java.awt.Dimension(90, 20));
        jTextField1.setPreferredSize(new java.awt.Dimension(90, 20));
        jPanel3.add(jTextField1);

        jButton2.setText("Connect");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jPanel3.add(jButton2);

        jPanel1.add(jPanel3, java.awt.BorderLayout.NORTH);

        jScrollPane1.setBorder(new javax.swing.border.TitledBorder("User List"));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(200, 300));
        jScrollPane1.setViewportView(jList1);

        jPanel4.add(jScrollPane1);

        jPanel1.add(jPanel4, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel1, java.awt.BorderLayout.EAST);

        jTextField2.setText("Type your messages here");
        jTextField2.setPreferredSize(new java.awt.Dimension(300, 20));
        jTextField2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField2ActionPerformed(evt);
            }
        });

        jPanel2.add(jTextField2);

        jButton1.setText("Send");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jPanel2.add(jButton1);

        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

        jScrollPane2.setAutoscrolls(true);
        jScrollPane2.setFocusable(false);
        jTextArea1.setEditable(false);
        jTextArea1.setFocusable(false);
        jScrollPane2.setViewportView(jTextArea1);

        getContentPane().add(jScrollPane2, java.awt.BorderLayout.WEST);

        pack();
    }//GEN-END:initComponents

    /**
     * Method called when the GUI is closed by the user.
     * @param evt The window event that closes the window.
     */
    private void closingWindow(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closingWindow
        // TODO add your handling code here:
        this.icc.close();
        this.dispose();
    }//GEN-LAST:event_closingWindow

    /**
     * Sends a message to the chat client. The message that is send is
     * the one the user introduced in the lower textfield.
     * @param evt The event that calls this method.
     */
    private void jTextField2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField2ActionPerformed
        // TODO add your handling code here:
        this.jButton1ActionPerformed(evt);
    }//GEN-LAST:event_jTextField2ActionPerformed

    /**
     * Method called when the client connects/disconnects itself from
     * the server.
     * @param evt The event that calls this method.
     */
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        // TODO add your handling code here:               
        if (jButton2.getText().compareTo("Connect")==0) {
            this.username = this.jTextField1.getText();
            boolean result = this.icc.connect(this.username);
            if (result) {
                this.jTextArea1.setText("Connected!!\n");
                this.jButton2.setText("Disconnect");
            }
            else {
                this.jTextArea1.setText("Unable to connect, check maybe your username.\n");
            }
        }
        else {
            boolean result = this.icc.disconnect(this.username);
            if (result) {
                this.jTextArea1.setText("You successfully disconnected from the server.\n");
                this.jList1.setListData(new String[0]);            
                this.jButton2.setText("Connect");        
            }
            else {
                this.jTextArea1.setText("Unable to disconnect.\n");
            }
        }
    }//GEN-LAST:event_jButton2ActionPerformed

    /**
     * Sends a message to the chat client. The message that is send is
     * the one the user introduced in the lower textfield.
     * @param evt The event that calls this method.
     */
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
           this.icc.sendMessage(new Message(this.username, this.jTextField2.getText().getBytes()));
           this.jTextField2.setText("");                               
    }//GEN-LAST:event_jButton1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    // End of variables declaration//GEN-END:variables
    
}
