/*
 * ChatClientListener.java
 *
 * Created on 19 March 2005, 00:43
 */

package ch.epfl.lpd.ids.client;

import java.rmi.Remote;
import java.rmi.RemoteException;

import ch.epfl.lpd.ids.serialization.IMessage;

/**
 * Remote interface of the {@link ch.epfl.lpd.ids.client.ChatClient}. This
 * interface is used by the server to have a remote reference to its clients.
 * @author  Sebastien Baehni
 */
public interface IChatClientListener extends Remote {
    
    /**
     * Method called by the {@link ch.epfl.lpd.ids.server.ChatServer} to inform
     * its client that a new message has been sent by one client.
     * @param msg The message that has been sent by one client to the server.
     * @throws java.rmi.RemoteException If a remote exception occurs.
     */
    public void newMessage(IMessage msg) throws RemoteException;
    
    /**
     * Method called by the {@link ch.epfl.lpd.ids.server.ChatServer} to inform
     * its clients that new clients connect.
     * @param clients The list of the clients connected to the server.
     * @throws java.rmi.RemoteException If a remote exception occurs.
     */
    public void newListOfClients(String[] clients) throws RemoteException;
    
}
