package ch.epfl.lpd.ids.utils;

import java.util.ArrayList;
/**
 * Class implementing the {@link
 * ch.epfl.lpd.ids.utils.IBlockingQueue}. This class represents a
 * blocking queue and waits until no new element are in the queue.
 * This class is generic and accepts objects of type T.
 * @author Sebastien Baehni
 */
public class MyBlockingQueue<T> implements IBlockingQueue<T> {
    
    /**
     * The array containing all the objects of the queue.
     */
    protected ArrayList<T> arrayList;
    
    
    /**
     * Creates a new instance of MyBlockingQueue. This creates only an
     * empty {@link java.util.ArrayList }
     */
    public MyBlockingQueue() {
        this.arrayList = new ArrayList<T>();
    }
    
    /**
     * Method used to retrieve the last, and not already get, element
     * of this queue.  This method waits until a new element is put
     * into the queue.
     * @return The last object of this queue that has not already been
     * retrieved.
     * @throws java.lang.InterruptedException If an exception occurs
     * while waiting for getting the last element of the queue.
     */
    public synchronized T get() throws InterruptedException {
        while (this.arrayList.size()==0) {
            wait();            
        }        
        return this.arrayList.remove(this.arrayList.size()-1);
    }
    
    /**
     * Method used to put a new element of type T into the queue
     * @param obj The object to put into the queue.
     */
    public synchronized void put(T obj) {
        this.arrayList.add(0,obj);
        notifyAll();
    }
    
}
