package ch.epfl.lpd.ids.utils;

/**
 * This class is the specification of a Blocking Queue. This class is
 * generic and handles object of type T.
 * @author Sebastien Baehni
 */
public interface IBlockingQueue<T> {
    
    /**
     * Method used to get a new object of type T. This method will
     * wait until new messages are in the queue.
     * @return The last object of type T of this queue.
     * @throws java.lang.InterruptedException If an exception occurs
     * while waiting for the next element of this queue.
     */
    public T get() throws InterruptedException;
    /**
     * Method used to put a new object of type T into this queue.
     * @param obj The object to put into this queue.
     */
    public void put(T obj);
    
}
