package ch.epfl.lpd.ids.server;

import ch.epfl.lpd.ids.serialization.IMessage;
/**
 * Specification of a chat server. A chat server should be able to
 * accept new chat clients, to accept disconnection of chat clients,
 * to send and receive messages from these clients and to give the
 * list of its connected clients.
 * @author Sebastien Baehni
 */
public interface IServer {
    
    /**
     * Method called by a chat client to connect to this server.
     * @param username The username of the client that wants to connect.
     * @return True if the client was able to connect, false otherwise.
     */
    public boolean connect(String username);
    /**
     * Method called by a chat client when it wants to be
     * disconnected.
     * @param username The username of the chat client that wants to
     * be disconnected.
     * @return True if the chat client was able to disconnect, false
     * otherwise.
     */
    public boolean disconnect(String username);
    /**
     * Method called by a chat client on the server when the chat
     * client wants to send a new message.
     * @param username The username of the client that sends this
     * message.
     * @param msg The {@link ch.epfl.lpd.ids.serialization.IMessage}
     * to send.
     */
    public void sendMessage(String username, IMessage msg);
    /**
     * Method used to get the last message sent from a chat client to
     * this server.
     * @param username The username of the client that wants to get
     * the last message sent.
     * @return The last {@link ch.epfl.lpd.ids.serialization.IMessage}
     * sent.
     */
    public IMessage getMessage(String username);

    /**
     * Method used to retrieve the list of the connected clients.
     * @return An array of string representing the list of the
     * connected clients.
     */
    public String[] getListOfClients();
    
    
}
