package ch.epfl.lpd.ids.gui;

/**
 * Specification of a Window Manager. This window manager is
 * implemented by the {@link ch.epfl.lpd.ids.CentralizedChat} class in order to
 * cleanly close the local chat application when no client is
 * available anymore.
 * @author Sebastien Baehni
 */
public interface IWindowManager {
    
    /**
     * Method called by a chat client when the user decides to close
     * its GUI and hence to terminate its execution.
     */
    public void closeClient();
    
}
