package ch.epfl.lpd.ids.client;

import ch.epfl.lpd.ids.serialization.IMessage;

/**
 * Specification of a chat client. This makes the interface between a
 * {@link ch.epfl.lpd.ids.gui.ClientGUI} and {@link
 * ch.epfl.lpd.ids.client.ChatClient} and let the {@link
 * ch.epfl.lpd.ids.gui.ClientGUI} being independant on the {@link
 * ch.epfl.lpd.ids.client.ChatClient} implementation.  A chat client
 * should be able to connect/disconnect from the server, send message
 * and dispose all the ressources that are associated to it.
 * @author Sebastien Baehni
 */
public interface IChatClient {
    
    /**
     * Method called by when the client want to connect to a server.
     * @param username The username of the client.
     * @return True if the client was able to connect, false
     * otherwise.
     */
    public boolean connect(String username);
    /**
     * Method called when the client wants to disconnect from the
     * server.
     * @param username The username of the client.
     * @return True if the client was able to disconnect from the
     * server. False otherwise.
     */
    public boolean disconnect(String username);
    /**
     * Method called when the client wants to send a message.
     * @param msg The message to be sent as a IMessage.
     */
    public void sendMessage(IMessage msg);
    /**
     * Method called when the client wants to release all the
     * ressources used by the instance of this {@link
     * ch.epfl.lpd.ids.client.IChatClient}.
     */
    public void close();
    
}
