/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lpd.ids.server;

import ch.epfl.lpd.ids.serialization.IMessage;
import ch.epfl.lpd.ids.serialization.Message;
import ch.epfl.lpd.ids.server.IServer;
import ch.epfl.lpd.ids.server.InternalClient;
import java.util.ArrayList;

public class ChatServer
implements IServer {
    ArrayList<InternalClient> clients = new ArrayList();

    public synchronized boolean connect(String username) {
        for (InternalClient client : this.clients) {
            if (client.getUsername().compareTo(username) != 0) continue;
            return false;
        }
        InternalClient client = new InternalClient(username);
        this.clients.add(client);
        return true;
    }

    public synchronized boolean disconnect(String username) {
        InternalClient toRemove = null;
        for (InternalClient client : this.clients) {
            if (client.getUsername().compareTo(username) != 0) continue;
            toRemove = client;
        }
        if (toRemove != null) {
            Message msg = new Message("Disconnection", "You have successfully be disconnected from the server.".getBytes());
            toRemove.putMessage(msg);
            this.clients.remove(toRemove);
            return true;
        }
        return false;
    }

    public synchronized void sendMessage(String username, IMessage msg) {
        for (InternalClient client : this.clients) {
            client.putMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage getMessage(String username) {
        InternalClient ic = null;
        ArrayList<InternalClient> arrayList = this.clients;
        synchronized (arrayList) {
            for (InternalClient client : this.clients) {
                if (client.getUsername().compareTo(username) != 0) continue;
                ic = client;
            }
        }
        if (ic == null) {
            return new Message("You are not connected.", "Sorry but you are not connected.".getBytes());
        }
        return ic.getNextMessage();
    }

    public synchronized String[] getListOfClients() {
        String[] usernames = new String[this.clients.size()];
        int i = 0;
        for (InternalClient client : this.clients) {
            usernames[i] = client.getUsername();
            ++i;
        }
        return usernames;
    }
}

