/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lpd.ids.gui;

import ch.epfl.lpd.ids.client.IChatClient;
import ch.epfl.lpd.ids.serialization.IMessage;
import ch.epfl.lpd.ids.serialization.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ClientGUI
extends JFrame
implements Observer {
    protected IChatClient icc;
    protected String username;
    private JButton jButton1;
    private JButton jButton2;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public ClientGUI(IChatClient icc) {
        this.icc = icc;
        this.initComponents();
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof IMessage) {
            String header = ((IMessage)arg).getHeader();
            String data = new String(((IMessage)arg).getData());
            this.jTextArea1.append(header + ":\n");
            this.jTextArea1.append(data + "\n");
            this.jScrollPane2.getVerticalScrollBar().setValue(this.jScrollPane2.getVerticalScrollBar().getValue() + this.jTextArea1.getHeight());
        }
        if (arg instanceof String[]) {
            this.jList1.setListData((String[])arg);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jButton2 = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel2 = new JPanel();
        this.jTextField2 = new JTextField();
        this.jButton1 = new JButton();
        this.jScrollPane2 = new JScrollPane(this.jTextArea1, 22, 32);
        this.jTextArea1 = new JTextArea(10, 30);
        this.setDefaultCloseOperation(0);
        this.setTitle("Chat Client");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ClientGUI.this.closingWindow(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jTextField1.setText("Username       ");
        this.jTextField1.setMinimumSize(new Dimension(90, 20));
        this.jTextField1.setPreferredSize(new Dimension(90, 20));
        this.jPanel3.add(this.jTextField1);
        this.jButton2.setText("Connect");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClientGUI.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton2);
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jScrollPane1.setBorder(new TitledBorder("User List"));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 300));
        this.jScrollPane1.setViewportView(this.jList1);
        this.jPanel4.add(this.jScrollPane1);
        this.jPanel1.add((Component)this.jPanel4, "Center");
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.jTextField2.setText("Type your messages here");
        this.jTextField2.setPreferredSize(new Dimension(300, 20));
        this.jTextField2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClientGUI.this.jTextField2ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jTextField2);
        this.jButton1.setText("Send");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClientGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jScrollPane2.setAutoscrolls(true);
        this.jScrollPane2.setFocusable(false);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFocusable(false);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.getContentPane().add((Component)this.jScrollPane2, "West");
        this.pack();
    }

    private void closingWindow(WindowEvent evt) {
        this.icc.close();
        this.dispose();
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
        this.jButton1ActionPerformed(evt);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.jButton2.getText().compareTo("Connect") == 0) {
            this.username = this.jTextField1.getText();
            boolean result = this.icc.connect(this.username);
            if (result) {
                this.jTextArea1.setText("Connected!!\n");
                this.jButton2.setText("Disconnect");
            } else {
                this.jTextArea1.setText("Unable to connect, check maybe your username.\n");
            }
        } else {
            boolean result = this.icc.disconnect(this.username);
            if (result) {
                this.jList1.setListData(new String[0]);
                this.jButton2.setText("Connect");
            } else {
                this.jTextArea1.setText("Unable to disconnect.\n");
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.icc.sendMessage(new Message(this.username, this.jTextField2.getText().getBytes()));
        this.jTextField2.setText("");
    }
}

