/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lpd.ids.client;

import ch.epfl.lpd.ids.client.ClientListFetcher;
import ch.epfl.lpd.ids.client.IChatClient;
import ch.epfl.lpd.ids.gui.ClientGUI;
import ch.epfl.lpd.ids.gui.IWindowManager;
import ch.epfl.lpd.ids.serialization.IMessage;
import ch.epfl.lpd.ids.server.IServer;
import java.util.Observable;

public class ChatClient
extends Observable
implements Runnable,
IChatClient {
    private ClientGUI gui = new ClientGUI(this);
    protected IServer server;
    protected IWindowManager iw;
    protected String username = "";
    protected boolean connected = false;
    protected ClientListFetcher clf;

    public ChatClient(IServer server, IWindowManager iw) {
        this.addObserver(this.gui);
        this.server = server;
        this.iw = iw;
        this.clf = new ClientListFetcher(server, this.gui);
        this.gui.setVisible(true);
    }

    public boolean connect(String username) {
        if (!this.connected) {
            this.connected = this.server.connect(username);
            if (this.connected) {
                this.clf.setStarted(true);
                new Thread(this.clf).start();
                this.username = username;
                new Thread(this).start();
            }
        }
        return this.connected;
    }

    public boolean disconnect(String username) {
        if (this.connected) {
            this.connected = false;
            boolean result = this.server.disconnect(username);
            if (result) {
                this.clf.setStarted(false);
            } else {
                this.connected = true;
            }
            return result;
        }
        return false;
    }

    public void sendMessage(IMessage msg) {
        if (this.connected) {
            this.server.sendMessage(this.username, msg);
        }
    }

    public void close() {
        this.disconnect(this.username);
        this.clf.setStarted(false);
        this.iw.closeClient();
    }

    public void run() {
        while (this.connected) {
            IMessage msg = this.server.getMessage(this.username);
            this.setChanged();
            this.notifyObservers(msg);
        }
    }
}

