/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lpd.ids;

import ch.epfl.lpd.ids.client.ChatClient;
import ch.epfl.lpd.ids.gui.IWindowManager;
import ch.epfl.lpd.ids.server.ChatServer;

public class CentralizedChat
implements IWindowManager {
    protected ChatClient[] clients;
    protected int numberOfClients;
    protected int numberOfActiveClients;

    public CentralizedChat(int numberOfClients) {
        this.numberOfClients = numberOfClients;
        this.clients = new ChatClient[this.numberOfClients];
    }

    public void start() {
        ChatServer server = new ChatServer();
        for (int i = 0; i < this.numberOfClients; ++i) {
            this.clients[i] = new ChatClient(server, this);
            ++this.numberOfActiveClients;
        }
    }

    public void closeClient() {
        --this.numberOfActiveClients;
        if (this.numberOfActiveClients == 0) {
            System.exit(0);
        }
    }

    public static void printUsage() {
        System.out.println("Usage:");
        System.out.println("java ch.epfl.lpd.ids.Main numberOfClients");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            CentralizedChat.printUsage();
            System.exit(1);
        } else {
            try {
                CentralizedChat main = new CentralizedChat(Integer.parseInt(args[0]));
                main.start();
            }
            catch (NumberFormatException nfe) {
                System.out.println("Please enter a valid number.");
                CentralizedChat.printUsage();
            }
        }
    }
}

